	% Example 5.13 Delay-complementarry, linear-phase, lowpass FIR 
	%
	% 	Author: 				Lars Wanhammar 2004-08-17
	% 	Modified by: 	 
	% 	Copyright:			by authors - not released for commercial use
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	wcT = 0.3*pi;
	wsT = 0.6*pi;
	wTedges = [wcT wsT]; 		% Band edges
	b = [1 0];				% Gain in the bands
	dc = 0.02; 				% Acceptable deviations
	ds = 0.0025;
	d = [dc ds];
	AmaxS = 20*log10((1+dc)/(1-dc))
	AminS = 20*log10((1+dc)/ds)
	fsample = 2*pi;
	%[N, Be, D, W] = remezord(wT, b, d, fsample);
	[Norder, Be, D, W] = L_PHASE_LP_FIR_ORDER(wTedges, d)
	Norder 						% Estimated filter order
	
	Norder = 16  				% Selected filter order
%	[h, ERR] = remez(N, Be, D, W);
	[h, Err] = REMEZ_FIR(Norder, Be, D, W, 'm')
	hn = (1/(1+Err))*h; 	% Normalize the max gain to 1
	Err
	hnc = -hn;
	hnc(Norder/2+1) = 1 + hnc(Norder/2+1); % Complementary impulse response
	
	wT = linspace(0,pi,2000);
	H = freqz(hn,1, wT);	
	Hc = freqz(hnc,1, wT);
	Mag = H_2_MAG(H);	
	Magc = H_2_MAG(Hc);
	
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
	figure(1)
	subplot('position', [0.09 0.56 0.40 0.40])
	plot(wT, Mag,'linewidth', lw);   	% Magnitude response
	yminaxis = -70; 
	axis([0 pi yminaxis 0]);
	ylabel('{|\itH}({\ite^j^\omega^T})|  dB','FontName', fn,'FontSize',fs);	
	%	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax, lab);
	grid on;
	zoom on;
	
	subplot('position', [0.09 0.08 0.40 0.40])
	plot(wT, Magc,'linewidth',lw);   	% Magnitude response
	yminaxis = -70; 
	axis([0 pi yminaxis 0]);
	ylabel('{|\itH_C}({\ite^j^\omega^T})| dB','FontName', fn,'FontSize',fs);	
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax, lab);
	grid on;
	zoom on
	
	subplot('position', [0.58 0.56 0.40 0.40]) 
	plot(wT, abs(H),'linewidth', lw);   	% Magnitude response
	ylabel('{|\itH}({\ite^j^\omega^T})|','FontName', fn,'FontSize',fs);
	axis([0 pi 0 1]);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax,lab);
	grid on;
	zoom on
	
	subplot('position', [0.58 0.08 0.40 0.40]) 
	plot(wT, abs(Hc),'linewidth', lw);   	% Magnitude response
	ylabel('{|\itH_c}({\ite^j^\omega^T})|','FontName', fn,'FontSize',fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	axis([0 pi 0 1]);
	set(gca,'FontName', fn,'FontSize', fs);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi'};
	xtick(ax, lab);
	grid on;
	zoom on
	
	figure(2)
	subplot('position', [0.1 0.55 0.86 0.38])
	PLOT_IMPULSE_RESPONSE_Z(hn)
%	axis([0 18 -0.4 0.6]);
	%===		grid on;		
	subplot('position', [0.1 0.08 0.86 0.38])
	PLOT_IMPULSE_RESPONSE_Z(hnc)
%	axis([0 18 -0.4 0.6]);
 
	%PLOT_SEQUENCE(hnc, '{\ith_c}({\itn})')
	
		
